<?php

/*
Implementation of the get-updates verb.
Written by Chris Jean for iThemes.com
Version 1.0.0

Version History
	1.0.0 - 2014-03-28 - Chris Jean
		Initial version
*/


class Ithemes_Sync_Verb_Get_Notices extends Ithemes_Sync_Verb {
	public static $name = 'get-notices';
	public static $description = 'Receive notices generated by other code running on the site.';
	public static $status_element_name = 'notices';
	public static $show_in_status_by_default = true;
	
	private $default_arguments = array(
		'clear-urgent-notices' => true,
	);
	
	
	public function run( $arguments ) {
		$arguments = Ithemes_Sync_Functions::merge_defaults( $arguments, $this->default_arguments );
		
		require_once( $GLOBALS['ithemes_sync_path'] . '/notice-handler.php' );
		
		$normal = $GLOBALS['ithemes_sync_notice_handler']->get_notices( $arguments );
		
		$urgent = $GLOBALS['ithemes_sync_notice_handler']->get_urgent_notices();
		
		if ( $arguments['clear-urgent-notices'] ) {
			$GLOBALS['ithemes_sync_notice_handler']->clear_urgent_notices();
		}
		
		return compact( 'normal', 'urgent' );
	}
}
